(**********************************************************
 *                                                        *
 *                      SHANNON 9000                      *
 *                        VER 1.0                         *
 *                                                        *
 *            WRITTEN BY CARLOS JUSTINIANO III            *
 *                                                        *
 *   THIS PROGRAM PLAYS THE GAME OF OTHELLO.  ALL LEGAL   *
 *   MOVES ARE EVALUATED ON THE BASES OF A 1 PLY SEARCH   *
 *   BASED ON MATERIAL.                                   *
 *                                                        *
 *   DESIGNED ON A DEC PDP 11/44.                         *
 *   WRITTEN IN PASCAL-2 ON OCT. 86                       *
 *                                                        *
 *   LAST UPDATE: FEB 5, 1987                             *
 *                                                        *
 **********************************************************)



PROGRAM OTHELLO(INPUT,OUTPUT);
CONST
   WHITE = 1;
   BLACK = 2;
TYPE
   STRING = PACKED ARRAY[1..80] OF CHAR;
   ML = RECORD
             COLOR :CHAR;
             M1    :CHAR;
             M2    :INTEGER;
        END;
VAR
   NAME:STRING;
   GAME_STAT:INTEGER;
   MOVE_LOG:ARRAY[1..64] OF ML;
   LM : ARRAY[1..30,1..5] OF INTEGER;  
   COND : ARRAY[1..10,1..2] OF INTEGER;
   TRACKING : ARRAY[1..2000,1..5] OF INTEGER;
   BOARD,SQ : ARRAY[0..9,0..9] OF INTEGER;
   PROGRAM_END_FLAG : BOOLEAN;
   CH:CHAR;
   LP,TP,B,W,MOVE_TOTAL : INTEGER; 



(*****************************)
(* INTRODUCTION              *)
(* DISPLAY GAME INTRODUCTION *)
(*****************************)
PROCEDURE INTRODUCTION;
BEGIN
    WRITELN('*********************************');
    WRITELN('*          SHANNON 9000         *');
    WRITELN('*         OTHELLO  PROGRAM      *');
    WRITELN('*             Ver 1.0           *');
    WRITELN('*********************************');
    WRITELN;     
    WRITELN;
    WRITELN('WELCOME TO OTHELLO.');
    WRITELN;
    WRITELN('FOR DIRECTIONS AND OTHER HELPFUL HINTS');
    WRITELN('TYPE "HELP" AT THE "->" PROMPT.');
    WRITELN;
    WRITELN('SPECIAL THANKS TO TERRY KENNEDY AND');
    WRITELN('GLENN MEINHART FOR MIDNIGHT HACKING');
    WRITELN('PRIVILEGES.');
    WRITELN;        
    WRITELN('                         C.JUSTININANO');
    WRITELN;
END;


(******************************************)
(* HELP_USER                              *)
(* THIS ROUTINE PROVIDES HELP TO THE USER *)
(******************************************)
PROCEDURE HELP_USER;
VAR CH:CHAR;
BEGIN
    WRITELN;
    WRITELN(NAME,',');
    WRITELN('OTHELLO IS A GAME PLAYED ON AN 8 BY 8 CHECKER-LIKE');
    WRITELN('BOARD, USING DISC WHICH ARE WHITE ON ONE SIDE AND ');
    WRITELN('BLACK ON THE OTHER.');
    WRITELN;
    WRITELN('THE OBJECT OF THE GAME IS TO BE THE PLAYER WITH THE');
    WRITELN('MOST OF HIS DISC REMAINING ON THE BOARD.');
    WRITELN;
    WRITELN('DEC OTHELLO, WAS WRITTEN IN PASCAL-2 ON A DEC PDP 11/44');
    WRITELN('ON OCTOBER 28, 1986.  THIS PROGRAM EVALUATES ALL LEGAL');
    WRITELN('MOVES AT THE FIRST PLY BASED ON MATERIAL.');
    WRITELN;
    WRITELN('IF YOU DONT KNOW HOW TO PLAY OTHELLO JUST ASK AROUND');
    WRITELN('SOMEONE IS BOUND TO KNOW THE BASIC RULES.');
    WRITELN;
    WRITELN('INORDER TO MAKE A MOVE IN DEC OTHELLO YOU MUST ENTER');
    WRITELN('THE LETTER LOCATION, THEN THE NUMBER LOCATION OF THE');
    WRITELN('SQUARE YOU WISH TO PLACE A PIECE ON.');
    WRITELN;
    WRITE(NAME,' PRESS THE RETURN KEY TO CONTINUE');
    READ(CH);
    WRITELN(*** MORE HELP ***);
    WRITELN('THE FOLLOWING IS A SUMMARY OF GAME COMMANDS:');
    WRITELN('COMMAND          PURPOSE');
    WRITELN('-------          -------');
    WRITELN('   D             DISPLAY BOARD');
    WRITELN('   G             DISPLAY MOVE LIST');
    WRITELN('   H             DISPLAY THIS HELP INFORMATION');
    WRITELN('   M             TELL PROGRAM YOU ARE READY TO MAKE A MOVE');
    WRITELN('   P             PASS');
    WRITELN('   Q             QUIT GAME PROGRAM');
    WRITELN('   S             SAVE GAME');
    WRITELN('   T             DISPLAY TIME');
    WRITELN('   R             RESTORE GAME');
    WRITELN('   ?             DISPLAY GAME STATS');
    WRITELN;
    WRITELN('TO ISSUE A COMMAND SIMPLY TYPE IT NEXT TO THE');
    WRITELN('GAME PROMPT "->"');
    WRITELN;
END;


(**************************************************)
(* INIT_SQ_VALUES                                 *)
(* THIS MODULE INITIZES THE VALUES OF EACH SQUARE *)
(* ON THE OTHELLO BOARD.                          *)
(**************************************************)
PROCEDURE INIT_SQ_VALUES;
BEGIN
    SQ[1,1]:=900; SQ[1,2]:=-200; SQ[1,3]:=  1; SQ[1,4]:=  1;
    SQ[1,5]:=  1; SQ[1,6]:=  1; SQ[1,7]:=-200; SQ[1,8]:=900;
    SQ[2,1]:=-200; SQ[2,2]:=-400; SQ[2,3]:=  0; SQ[2,4]:=  0;
    SQ[2,5]:=  0; SQ[2,6]:=  0; SQ[2,7]:=-400; SQ[2,8]:=-200;
    SQ[3,1]:=  1; SQ[3,2]:=  0; SQ[3,3]:=  0; SQ[3,4]:=   0;
    SQ[3,5]:=  0; SQ[3,6]:=  0; SQ[3,7]:=  0; SQ[3,8]:=   1;
    SQ[4,1]:=  1; SQ[4,2]:=  0; SQ[4,3]:=  0; SQ[4,4]:=  0;
    SQ[4,5]:=  0; SQ[4,6]:=  0; SQ[4,7]:=  0; SQ[4,8]:=  1;
    SQ[5,1]:=  1; SQ[5,2]:=  0; SQ[5,3]:=  0; SQ[5,4]:=  0;
    SQ[5,5]:=  0; SQ[5,6]:=  0; SQ[5,7]:=  0; SQ[5,8]:=  1;
    SQ[6,1]:=  1; SQ[6,2]:=  0; SQ[6,3]:=  0; SQ[6,4]:=  0;
    SQ[6,5]:=  0; SQ[6,6]:=  0; SQ[6,7]:=  0; SQ[6,8]:=  1;
    SQ[7,1]:=-200; SQ[7,2]:=-400; SQ[7,3]:= 0; SQ[7,4]:= 0;
    SQ[7,5]:=  0; SQ[7,6]:= 0; SQ[7,7]:=-400; SQ[7,8]:=-200;
    SQ[8,1]:=900; SQ[8,2]:=-200; SQ[8,3]:= 1; SQ[8,4]:=  1;
    SQ[8,5]:=  1; SQ[8,6]:=   1; SQ[8,7]:=-200; SQ[8,8]:=900;
END;


(*********************************************************)
(* INIT_BOARD                                            *)
(* INITIZE THE POSITION OF EACH OF THE FIRST FOUR PIECES *)
(* THAT ARE PLACED ON THE OTHELLO BOARD PRIOR TO THE     *)
(* START OF THE GAME.                                    *)
(*********************************************************)
PROCEDURE INIT_BOARD;
BEGIN
    BOARD[4,5]:=1;
    BOARD[5,4]:=1;
    BOARD[5,5]:=2;
    BOARD[4,4]:=2;
END;


(***************************************************)
(* INIT_CONDITIONS                                 *)
(* ARRAY OF VALUES USED TO DIRECT WERE THE PROGRAM *)
(* WILL SEARCH NEXT.  THESE VALUES SERVE AS OFFSET *)
(* VALUES TO X AND Y BOARD CORDINATES.             *)
(***************************************************)
PROCEDURE INIT_CONDITIONS;
BEGIN
    COND[1,1]:=-1;  COND[1,2]:=-1;
    COND[2,1]:= 0;  COND[2,2]:=-1;
    COND[3,1]:= 1;  COND[3,2]:=-1;
    COND[4,1]:=-1;  COND[4,2]:= 0;
    COND[5,1]:= 1;  COND[5,2]:= 0;
    COND[6,1]:=-1;  COND[6,2]:= 1;
    COND[7,1]:= 0;  COND[7,2]:= 1;
    COND[8,1]:= 1;  COND[8,2]:= 1;
END;


(******************************************************)
(* DISPLAY_BOARD                                      *)
(* THIS PROCEDURE DISPLAYS THE CURRENT BOARD POSITION *)
(* USING ASCII TEXT CHARACTERS                        *)
(******************************************************)
PROCEDURE DISPLAY_BOARD;
VAR
   X,Y,L: INTEGER;
BEGIN
    L := 9;
    WRITELN('        ------------------------');
    FOR X := 8 DOWNTO 1 DO
       BEGIN
           L := L - 1;
           FOR Y:= 1 TO 8 DO
              BEGIN
                  IF Y = 1
                    THEN WRITE(L,'|');
                  CASE BOARD[Y,X] OF
                      0: WRITE(' + ');
                      1: WRITE(' W ');
                      2: WRITE(' B ');
                  END;
                  IF Y = 8 
                    THEN WRITE('|');
              END;
           WRITELN;
       END;
    WRITELN('        ------------------------');
    WRITELN('         A  B  C  D  E  F  G  H');
END;


(*****************************************************)
(* GET USERS NAME                                    *)
(* THIS ROUTINE PROMPT THE USER FOR HIS/HER NAME     *)
(* THEN STORES IT IN A GLOBOL STRING CALLED NAME     *)
(*****************************************************)
PROCEDURE GET_USERS_NAME;
VAR
   ST: CHAR;
   PARSE_LINE :STRING;
   PLP,X :INTEGER;
 BEGIN
    FOR PLP:=1 TO 80 DO
       BEGIN
           PARSE_LINE[PLP]:=CHR(0);
           NAME[PLP]:=CHR(0);
       END;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITE('PLEASE ENTER YOUR NAME:');
    PLP:=0;
    REPEAT
         READ(ST);
         IF (ST >= 'a') AND (ST<= 'z') THEN ST:=CHR(ORD(ST)-ORD('a')+ORD('A'));
         PLP:=PLP+1;
         PARSE_LINE[PLP]:=ST;
    UNTIL ST=' ';   
    NAME:=PARSE_LINE;
    WRITELN('WELCOME ',NAME);
END;


(*****************************************************)
(* MOVELOG                                           *)
(* THIS PROCEDURE IS RESPONSIBLE FOR STORING ALL THE *)
(* MOVES MADE DURING THE COURSE OF A GAME.           *)
(* ***************************************************)
PROCEDURE MOVELOG(PLAYER,A,B:INTEGER);
VAR
   CH:CHAR;
BEGIN
    MOVE_TOTAL:=MOVE_TOTAL+1;
    IF PLAYER=1
      THEN CH:='W'
    ELSE CH:='B';
    MOVE_LOG[MOVE_TOTAL].COLOR:=CH;
    CASE A OF
        1:CH:='a';
        2:CH:='b';
        3:CH:='c';
        4:CH:='d';
        5:CH:='e';
        6:CH:='f';
        7:CH:='g';
        8:CH:='h';
    END;
    MOVE_LOG[MOVE_TOTAL].M1:=CH;
    MOVE_LOG[MOVE_TOTAL].M2:=B;
END;


(***********************************************)
(* DISPLAY_MOVELOG                             *)
(* THIS MODULE WILL DISPLAY A COMPLETE LIST OF *)
(* MOVES MADE DURING THE COURSE OF THE GAME.   *)
(***********************************************)
PROCEDURE DISPLAY_MOVELOG;
VAR LOOP_COUNT,J,X:INTEGER;
BEGIN
    J:=0;
    WRITELN;
    WRITELN('*** MOVE LIST ***');
    FOR X:=1 TO MOVE_TOTAL DO
       BEGIN
           J:=J+1;
           IF J > 5 
             THEN BEGIN
                      WRITELN;
                      J:=0;
                  END;
           WRITE(X,'. ',MOVE_LOG[X].COLOR,MOVE_LOG[X].M1,MOVE_LOG[X].M2:1);
       END;
    WRITELN;
END;


(**********************************************************)
(* SAVE_MOVELOG                                           *)
(* THIS PROCEDURE SAVES THE CONTENTS OF THE MOVELOG ARRAY *)
(* ONTO A DISK FILE.  ONCE THE USER EXITS TO THE SYSTEM   *)
(* HE/SHE CAN THEN COPY THE FILE TO A LINE PRINTER AND    *)
(* HAVE A COMPLETE LIST OF MOVES MADE.                    *)
(**********************************************************)
PROCEDURE SAVE_MOVELOG;
VAR
  F:TEXT;
  X,J:INTEGER;
BEGIN
    J:=0;
    WRITELN('SAVING MOVE LOG ...');
    REWRITE(F,'OTTO.LOG');
    WRITELN(F,' ');
    WRITELN(F,'THE FOLLOWING IS A MOVE BY MOVE RECORD OF AN');
    WRITELN(F,'OTHELLO GAME PLAYED AGAINST SHANNON.');
    WRITELN(F,' ');
    WRITELN(F,'WHITE: SHANNON 9000 (OTHELLO PROGRAM)');
    WRITELN(F,'BLACK: ',NAME);
    WRITELN(F,' ');
    FOR X:=1 TO MOVE_TOTAL DO
       BEGIN
           J:=J+1;
           IF J > 5 
             THEN BEGIN
                      WRITELN(F,X,'. ',MOVE_LOG[X].COLOR,MOVE_LOG[X].M1,MOVE_LOG[X].M2:1);
                      J:=0;
                  END
           ELSE WRITE(F,X,'. ',MOVE_LOG[X].COLOR,MOVE_LOG[X].M1,MOVE_LOG[X].M2:1);
       END;
    WRITELN(F,' ');
    WRITELN(F,' ');
    IF W>B
      THEN WRITELN(F,'WHITE WINS:',W:3,' TO ',B:2);
    IF B>W
      THEN WRITELN(F,'BLACK WINS:',B:3,' TO ',W:2);
    IF W=B
      THEN WRITELN(F,'TIED GAME:',B:3,' TO ',W:2);
    CLOSE(F);
    WRITELN('GAME SAVED.');
END;


(****************************************************************)
(* LEGAL_MOVES                                                  *)
(* THIS MODULE IS THE HEART OF THE OTHELLO PROGRAM, BECAUSE     *)
(* IT CONTAINS BOTH THE LEGAL MOVE GENERATOR AND THE            *)
(* EVALUATION FUNCTION.                                         *)
(* THE ALGORITHM USED FOR GENERATING LEGAL MOVES IS AS FOLLOWS: *)
(*         1: SCAN EACH SQUARE ON THE BOARD                     *)
(*            UNTIL A PIECE (OF THE SAME COLOR AS IN "PLAYER")  *)
(*            IS FOUND.                                         *)
(*         2: THEN TRAVEL IN EACH DIRECTION COUNTING ALL THE    *)
(*            PIECES THAT ARE THE OPPOSITE COLOR AS "PLAYER"    *)
(*            THAT CAN BE CAPTURED.                             *)
(*         3: STORE THE ABOVE INFORMATION IN AN ARRAY           *)
(*                                                              *)
(* THE ALGORITHM USED FOR POSITIONAL EVALUATION IS AS FOLLOWS:  *)
(*            E = MATERIAL + SQUARE VALUE                       *)
(****************************************************************)
PROCEDURE LEGAL_MOVES(PLAYER:INTEGER);
VAR
   A,Z,X,Y,ZZ,P:INTEGER;

PROCEDURE SCAN_DIRECTIONS(X_LO,Y_LO:INTEGER);
VAR
   Z9,NXL,NYL,X,Y,K: INTEGER;
   TOTAL_PIECES:INTEGER;
   CD :INTEGER;
   GO :BOOLEAN;
   GO2:BOOLEAN;
BEGIN
    FOR CD:=1 TO 8 DO
       BEGIN
           GO := TRUE; 
           GO2:= FALSE;
           TOTAL_PIECES := 0;
           IF BOARD[X_LO,Y_LO] <> 0
             THEN GO := FALSE;
           IF (BOARD[X_LO+COND[CD,1],Y_LO+COND[CD,2]] <> PLAYER) AND
              (BOARD[X_LO+COND[CD,1],Y_LO+COND[CD,2]] <> 0) AND
              (GO = TRUE)
             THEN BEGIN
                      NXL:=X_LO;
                      NYL:=Y_LO;
                      X:=0;
                      REPEAT
                           BEGIN
                               X:=X+1;
                               NXL := NXL + COND[CD,1];
                               NYL := NYL + COND[CD,2];
                               IF (NXL<1) OR (NXL>8) OR (NYL<1) OR (NYL>8)
                                 THEN BEGIN
                                          GO2:=TRUE;
                                          X:=9;
                                      END;
                               IF BOARD[NXL,NYL]=0
                                 THEN BEGIN
                                          X:=9;
                                          GO2:=TRUE;
                                      END;
                               IF (BOARD[NXL,NYL] = PLAYER) AND
                                  (GO2 = FALSE)
                                 THEN BEGIN
                                          LP:=LP+1;
                                          LM[LP,1]:=X_LO;
                                          LM[LP,2]:=Y_LO;
                                          LM[LP,4]:=CD;
                                          X:=9;
                                      END;
                           END;
                      UNTIL X=9;
                  END;
       END;
    FOR X:=1 TO LP DO
       BEGIN
           K:=0;
           LM[X,3]:=0;
           TOTAL_PIECES:=0;
           NXL:=LM[X,1];
           NYL:=LM[X,2];
           REPEAT
                BEGIN
                    K:=K+1;
                    GO2:=FALSE;
                    NXL:=NXL+COND[LM[X,4],1];
                    NYL:=NYL+COND[LM[X,4],2];
                    IF (NXL<1) OR (NXL>8) OR (NYL<1) OR (NYL>8)
                      THEN BEGIN 
                               GO2:= TRUE;
                               NXL:=0;
                           END;
                    IF BOARD[NXL,NYL]=PLAYER
                      THEN BEGIN
                               GO2:=TRUE;
                               K:=8;
                           END;
                    IF GO2 = TRUE
                      THEN K:=8;    
                    IF (GO2 <> TRUE) AND
                       (BOARD[NXL,NYL]<>PLAYER) AND
                       (BOARD[NXL,NYL]<>0)
                      THEN BEGIN
                               TP:=TP+1;
                               TOTAL_PIECES:=TOTAL_PIECES+1;
                               TRACKING[TP,1]:=NXL;
                               TRACKING[TP,2]:=NYL;
                               TRACKING[TP,3]:=X;
                               TRACKING[TP,4]:=LM[X,1];
                               TRACKING[TP,5]:=LM[X,2];
                               LM[X,3]:=LM[X,3]+TOTAL_PIECES;
                               LM[X,5]:=TOTAL_PIECES;
                           END;
                END;
           UNTIL K=8;
       END;
    (* EVALUATION FUNCTION USED TO BE HERE *)
END;

BEGIN
    LP:=0;
    TP:=0;
    FOR X:= 1 TO 8 DO
       BEGIN
           FOR Y:=1 TO 8 DO
              IF BOARD[X,Y] = 0               
                THEN SCAN_DIRECTIONS(X,Y);    
       END;
    (* MARK DUPS FOR DELETION *)
    FOR X:=1 TO LP DO
       FOR Z:=1 TO LP DO
          IF (LM[X,1]=LM[Z,1]) AND
             (LM[X,2]=LM[Z,2]) AND
             (Z<>X) AND (LM[Z,1]<>9)
            THEN BEGIN
                     LM[X,3]:=LM[X,3]+LM[Z,3];
                     LM[X,5]:=LM[X,5]+LM[Z,5];
                     LM[Z,1]:=9;
                     LM[Z,2]:=9;
                 END;
    (* DELETE DUPS *)
    Z:=0;
    FOR A:=1 TO LP DO
       IF LM[A,1]<>9
         THEN BEGIN
                  Z:=Z+1;
                  LM[Z,1]:=LM[A,1];
                  LM[Z,2]:=LM[A,2];
                  LM[Z,3]:=LM[A,3];
                  LM[Z,4]:=LM[A,4];
                  LM[Z,5]:=LM[A,5];
              END;
    LP:=Z;
    (* EVALUATION FUNCTION *)
    FOR ZZ:=1 TO LP DO
       BEGIN
           P:=SQ[LM[ZZ,1],LM[ZZ,2]];
           LM[ZZ,3]:=LM[ZZ,3]+P;
       END; 
END;


(*****************************************)
(* GAME_STATS                            *)
(* THIS PROCEDURE REPORTS THE GAME SCORE *) 
(*****************************************)
PROCEDURE GAME_STATS;
BEGIN
    IF W=B
      THEN WRITELN('BOTH SIDES HAVE THE SAME AMOUNT OF PIECES.');
    IF W>B 
     THEN WRITELN('WHITE IS WINNING WITH ',W:2,' TO ',B:2);
    IF B>W
    THEN WRITELN('BLACK IS WINNING WITH ',B:2,' TO ',W:2);
    WRITELN;
END;


(***************************************************)
(* DETERMINE_WINNER                                *)
(* THIS ROUTINE IS RESPONSIBLE FOR DETERMINING WHO *)
(* HAS WON THE GAME.                               *)
(***************************************************)
PROCEDURE DETERMINE_WINNER;
VAR
   X,Y,A_MOVE:INTEGER;
BEGIN
    A_MOVE:=0;
    W:=0;
    B:=0;
    FOR X:=1 TO 8 DO
       BEGIN
           FOR Y:=1 TO 8 DO
              BEGIN
                  IF BOARD[X,Y]=0
                    THEN A_MOVE:=1;
                  IF BOARD[X,Y]=1
                    THEN W:=W+1;
                  IF BOARD[X,Y]=2
                    THEN B:=B+1;
              END;
       END;
    IF (A_MOVE=0) AND (B>W)
      THEN BEGIN
               WRITELN;
               WRITELN;
               WRITELN('THANK YOU FOR A GOOD GAME.  YOU HAVE BEATEN ME.');
               WRITELN('THE FINAL GAME RESULTS WERE:');
               WRITELN('WHITE:',W);
               WRITELN('BLACK:',B);
               GAME_STAT:=0;
               PROGRAM_END_FLAG:=TRUE;
           END;
    IF (A_MOVE=0) AND (W>B)
      THEN BEGIN
               WRITELN;
               WRITELN;
               WRITELN('IM SORRY TO TELL YOU THAT YOU HAVE LOST THE GAME.');
               WRITELN('THE FINAL GAME RESULTS WERE:');
               WRITELN('WHITE:',W:2);
               WRITELN('BLACK:',B:2);
               GAME_STAT:=0;
               PROGRAM_END_FLAG:=TRUE;
           END;
END;


(**********************************************)
(* LIST_MOVES                                 *)
(* THIS MODULE LIST ALL OF BLACKS LEGAL MOVES *)
(**********************************************)
PROCEDURE LIST_MOVES;
VAR X:INTEGER;
BEGIN
    LEGAL_MOVES(BLACK);
    WRITELN('*** LIST OF LEGAL MOVES ***');
    WRITELN('YOU MAY PLACE A PIECE ON ANY ONE OF THE ');
    WRITELN('FOLLOWING SQUARES:');
    WRITELN;
    FOR X:=1 TO LP DO
       BEGIN
           CASE LM[X,1] OF
               1:CH:='A'; 
               2:CH:='B';
               3:CH:='C';
               4:CH:='D';
               5:CH:='E';
               6:CH:='F';
               7:CH:='G';
               8:CH:='H';
               ELSE CH:=' ';
           END; 
           WRITELN(X:3,'..',CH,LM[X,2]:1,LM[X,3]:5,LM[X,5]:5);
       END;
       WRITELN;
END;


(*************************************************)
(* PROGRAM_TO_MOVE                               *)
(* THIS ROUTINE IS RESPONSIBLE FOR MAKING A MOVE *)
(* FOR THE PROGRAM.                              *)
(* THIS ROUTINE ALSO HANDLES THE CHANGING VALUES *)
(* OF CORNER SQUARES.                            *)
(*************************************************)
PROCEDURE PROGRAM_TO_MOVE;
LABEL 1;
VAR
  TEMP,X,M,BEST_MOVE:INTEGER;
  CH:CHAR;
  T:REAL;
BEGIN
    BEST_MOVE:=1;
    LEGAL_MOVES(WHITE);
    TEMP:=0;
    FOR X:=1 TO LP DO
       BEGIN
           IF (LM[X,3] > TEMP) OR (LM[X,3] = TEMP)
             THEN BEGIN
                      BEST_MOVE:=X;
                      TEMP:=LM[X,3];
                  END;
       END;
    FOR X:=1 TO LP DO
       BEGIN
           IF (LM[X,3]=LM[BEST_MOVE,3]) AND
              (BEST_MOVE <> X)
             THEN BEGIN
                      M:=ROUND(TIME)*X;
                      T:=M/2;
                      IF T=TRUNC(T)
                        THEN BEGIN
                                 BEST_MOVE:=X;
                                 WRITELN('*** DEBUG TEST #1 - (moves switched)');
                                 GOTO 1;
                             END;
                  END;
       END;
1:
    BOARD[LM[BEST_MOVE,1],LM[BEST_MOVE,2]]:=WHITE;
    IF (LM[BEST_MOVE,1]=1) AND (LM[BEST_MOVE,2]=1)
      THEN BEGIN
               SQ[2,1]:=0;
               SQ[2,2]:=0;
               SQ[1,2]:=0;
           END;
    IF (LM[BEST_MOVE,1]=1) AND (LM[BEST_MOVE,2]=8)
      THEN BEGIN
               SQ[1,7]:=0;
               SQ[2,7]:=0;
               SQ[2,8]:=0;
           END;
    IF (LM[BEST_MOVE,1]=8) AND (LM[BEST_MOVE,2]=1)
      THEN BEGIN
               SQ[7,1]:=0;
               SQ[7,2]:=0;
               SQ[8,2]:=0;
           END;
    IF (LM[BEST_MOVE,1]=8) AND (LM[BEST_MOVE,2]=8)
      THEN BEGIN
               SQ[8,7]:=0;
               SQ[7,7]:=0;
               SQ[7,8]:=0;
           END;
    FOR X:=1 TO TP DO
       BEGIN
           IF (TRACKING[X,4]=LM[BEST_MOVE,1]) AND
              (TRACKING[X,5]=LM[BEST_MOVE,2])
             THEN BOARD[TRACKING[X,1],TRACKING[X,2]]:=WHITE;
       END;
    CASE LM[BEST_MOVE,1] OF
        1:CH:='A';
        2:CH:='B';
        3:CH:='C';
        4:CH:='D';
        5:CH:='E';
        6:CH:='F';
        7:CH:='G';
        8:CH:='H';
        ELSE CH:=' ';
    END; 
    WRITELN;
    WRITELN;
    IF LP < 1
      THEN WRITELN('I DONT HAVE A LEGAL MOVE SO I PASS PLAY OVER TO YOU.')
    ELSE BEGIN
             WRITELN;
             WRITE('I PLACED A PIECE ON ',CH,LM[BEST_MOVE,2]:1);
             IF LM[BEST_MOVE,5] < 10
               THEN WRITE(' CAPTURING',LM[BEST_MOVE,5]:2,' OF YOUR PIECES.')
             ELSE WRITE(' CAPTURING ',LM[BEST_MOVE,5]:2,' OF YOUR PIECES.');
             WRITELN;
         END;
    MOVELOG(WHITE,LM[BEST_MOVE,1],LM[BEST_MOVE,2]);
    DISPLAY_BOARD;         
END;


(****************************************************************)
(* HUMAN_PLAYER_TO_MOVE                                         *)
(* THIS ROUTINE PROMTS THE USER FOR A MOVE, AND THEN DETERMINES *)
(* IF THE MOVE IS A VALID ONE.  IF THE MOVE IS VALID, THE       *)
(* PROGRAM THEN UPDATES THE CURRENT POSITION                    *)
(****************************************************************)
PROCEDURE HUMAN_PLAYER_TO_MOVE;
VAR
   CH:CHAR;
   ERR,CONT,VALID_MOVE:BOOLEAN;
   C,X,Y,XCOR,YCOR,GOTCHA:INTEGER;
   MOVE_STRING:PACKED ARRAY[1..20] OF CHAR;
BEGIN
    ERR:=FALSE;
    VALID_MOVE:=FALSE;
    LEGAL_MOVES(BLACK);
    C:=0; 
    WRITELN;
    WRITE('ENTER YOUR MOVE: ');
    REPEAT
         READ(CH);
         C:=C+1;
         MOVE_STRING[C]:=CH;
    UNTIL CH = ' ';
    ERR:=FALSE;
    CASE MOVE_STRING[1] OF
        'A':XCOR:=1;
        'B':XCOR:=2;
        'C':XCOR:=3;
        'D':XCOR:=4;
        'E':XCOR:=5;
        'F':XCOR:=6;
        'G':XCOR:=7;
        'H':XCOR:=8;
        ELSE ERR:=TRUE;
    END;
    CASE MOVE_STRING[2] OF
        '1':YCOR:=1;
        '2':YCOR:=2;
        '3':YCOR:=3;
        '4':YCOR:=4;
        '5':YCOR:=5;
        '6':YCOR:=6;
        '7':YCOR:=7;
        '8':YCOR:=8;
        ELSE ERR:=TRUE;
    END;
    FOR X:= 1 TO LP DO
       BEGIN
           IF (XCOR=LM[X,1]) AND (YCOR=LM[X,2])
             THEN BEGIN 
                      VALID_MOVE:=TRUE;
                      GOTCHA:=X;
                  END;
       END;
    IF VALID_MOVE <> TRUE
      THEN ERR:=TRUE;     
    IF ERR = TRUE
      THEN BEGIN
               WRITELN;
               WRITELN('ERROR INVALID MOVE.');
               WRITELN('TYPE "HELP" TO VIEW CORRECT SYNTAX.');
           END
    ELSE   BEGIN
               BOARD[XCOR,YCOR]:=BLACK;
               FOR Y:=1 TO TP DO
                  BEGIN
                      IF (TRACKING[Y,4]=LM[GOTCHA,1]) AND
                         (TRACKING[Y,5]=LM[GOTCHA,2])
                        THEN BOARD[TRACKING[Y,1],TRACKING[Y,2]]:=BLACK;
                  END;  
           END;
      IF VALID_MOVE <> FALSE
        THEN BEGIN
                 MOVELOG(BLACK,XCOR,YCOR);
                 PROGRAM_TO_MOVE; 
             END;
END;      


(*******************************************************)
(* PASS                                                *)
(* THIS ROUTINE ALLOWS THE USER TO PASS PLAY OVER TO   *)
(* THE PROGRAM.(USED WHEN THE USER DOESNT HAVE A LEGAL *)
(* MOVE.                                               *)
(*******************************************************)
PROCEDURE PASS;
BEGIN
    LEGAL_MOVES(BLACK);
    IF LP>0
      THEN BEGIN
               WRITELN(NAME,',');
               WRITELN('IAM SORRY TO TELL YOU THAT YOU CANT PASS.');
               WRITELN('YOU HAVE ',LP:1,' POSSIBLE MOVES.');
           END
    ELSE PROGRAM_TO_MOVE;
END;


(************************************************)
(* STORE_GAME                                   *)
(* THIS ROUTINE SAVES THE CURRENT GAME POSITION *)
(* ONTO A DISK FILE.                            *)
(* THE GAME CAN THEN LATER BE RETRIEVED, AND    *)
(* PLAY RESUMES.                                *)
(************************************************)
PROCEDURE STORE_GAME;
VAR
  F:TEXT;
  X,Y:INTEGER;
BEGIN
    WRITELN('SAVING GAME ...');
    REWRITE(F,'OTTO.GAM');
    WRITE(F,GAME_STAT);
    FOR X:=1 TO 8 DO
       FOR Y:=1 TO 8 DO
          WRITE(F,BOARD[X,Y]);
    WRITE(F,MOVE_TOTAL);
    FOR X:=1 TO MOVE_TOTAL DO
       WRITE(F,MOVE_LOG[X].COLOR,MOVE_LOG[X].M1,MOVE_LOG[X].M2);
    WRITE(F,W,B);
    CLOSE(F);
    SAVE_MOVELOG;
END;


(************************************************)
(* RESTORE_GAME                                 *)
(* THIS ROUTINE LOADS THE LAST CURRENT POSITION *)
(* INTO MEMORY, ALLOWING A SAVED GAME TO BE     *)
(* CONTINUED.                                   *)
(************************************************)
PROCEDURE RESTORE_GAME;
VAR
  F:TEXT;
  X,Y:INTEGER;
BEGIN
    WRITELN('LOADING GAME ...');
    RESET(F,'OTTO.GAM');
    READ(F,GAME_STAT);
    FOR X:=1 TO 8 DO
       FOR Y:=1 TO 8 DO
          READ(F,BOARD[X,Y]);
    READ(F,MOVE_TOTAL);
    FOR X:=1 TO MOVE_TOTAL DO
       READ(F,MOVE_LOG[X].COLOR,MOVE_LOG[X].M1,MOVE_LOG[X].M2);
    READ(F,W,B);
    CLOSE(F);
    WRITELN('BOARD RESTORED.');
    DISPLAY_BOARD;
END;


(******************************************)
(* STATUS CHECK                           *)
(* CHECKS TO SEE IF A GAME IS ALREADY IN  *)
(* PROGRESS AND IF SO - THEN PROMPTS THE  *)
(* USER IF HE WANTS TO CONTINUE THAT GAME *)
(* OR START A NEW ONE.                    *)
(******************************************)
PROCEDURE STATUS_CHECK;
LABEL 1;
VAR
  CH:CHAR;
  F:TEXT;
  STATUS:INTEGER;
BEGIN
    RESET(F,'SY:','OTTO.GAM',STATUS);
    IF IOERROR(F)
      THEN GOTO 1
    ELSE BEGIN
             READ(F,GAME_STAT);  (* IF GAME STAT IS EQUAL TO 1 THEN A *)
                                 (* GAME IS ALREADY IN PROGRESS.      *)
             IF GAME_STAT<>1
               THEN GOTO 1
             ELSE BEGIN
                      WRITELN;
                      WRITELN('THERE IS ALREADY A GAME IN PROGRESS ',NAME);
                      WRITELN('WOULD YOU LIKE TO CONTINUE THAT GAME OR');
                      WRITELN('WOULD YOU LIKE TO START A NEW GAME ?');
                      WRITELN;
                      WRITE('NEW GAME (Y/N)');
                      READ(CH);
                      IF (CH='Y') OR (CH='y')
                        THEN BEGIN
                                 WRITELN;
                                 WRITELN('STARTING A NEW GAME.');
                                 GOTO 1;
                             END
                      ELSE BEGIN
                               WRITELN; WRITELN;
                               WRITELN('RESTORE OLD GAME - PLEASE STAND BY..');
                               CLOSE(F);
                               RESTORE_GAME;
                           END;
                  END; 
          END;         
    CLOSE(F);
1:            
END;

                      

(*********************************************)
(* QUITTER                                   *)
(* THIS ROUTINE PRINTS A MESSAGE FOR QUITERS *)
(*********************************************)
PROCEDURE QUITTER;
BEGIN
    WRITELN;
    WRITELN(NAME,',');
    WRITELN('I REGRET TO INFORM YOU THAT BY QUITING,');
    WRITELN('YOU HAVE FORFITTED YOUR GAME.  I GUESS');
    WRITELN('THAT MAKES ME THE WINNER.');
    GAME_STAT:=0;
    PROGRAM_END_FLAG := TRUE;
END;


(*******************************************************)
(* DISPLAY TIME                                        *)
(* THIS ROUTINE GETS THE CURRENT TIME FROM THE SYSTEM  *)
(* AND INFORMS THE USER.                               *)
(*******************************************************)
PROCEDURE DISPLAY_TIME;
VAR
  HRS,MINS:INTEGER;
  AMPM:PACKED ARRAY[1..2] OF CHAR;
BEGIN
    MINS:=0; HRS:=0;
    MINS:=ROUND(TIME*60);
    HRS:=MINS DIV 60;
    MINS:=MINS MOD 60;
    IF (HRS<12)
      THEN AMPM:='AM'
    ELSE IF (HRS=12) AND (MINS=0)
           THEN AMPM:='M '
         ELSE AMPM:='PM';
    WRITE('AT THE SOUND OF THE TONE IT IS: ',CHR(7),((HRS+11) MOD 12+1):2);
    WRITE(':',MINS DIV 10:1,MINS MOD 10:1,AMPM:3);
    WRITELN;
END;


(************************************************)
(* PARSER                                       *)
(* THIS ROUTINE PROMPTS THE USER FOR A COMMAND. *)
(* THEN ACTS ACCORDINGLY.                       *)
(************************************************)        
PROCEDURE PARSER;
VAR
   ST: CHAR;
   PARSE_LINE :STRING;
   PLP,X :INTEGER;
 BEGIN
    FOR PLP:=1 TO 80 DO
       PARSE_LINE[PLP]:=CHR(0);
    WRITELN;
    WRITE('->');
    PLP:=0;
    REPEAT
         READ(ST);
         IF (ST >= 'a') AND (ST<= 'z') THEN ST:=CHR(ORD(ST)-ORD('a')+ORD('A'));
         PLP:=PLP+1;
         PARSE_LINE[PLP]:=ST;
    UNTIL ST=' ';   
    CASE PARSE_LINE[1] OF
        '?' :GAME_STATS;
        'M' :HUMAN_PLAYER_TO_MOVE;
        'D' :DISPLAY_BOARD;
        'P' :PASS;
        'H' :HELP_USER;
        'L' :LIST_MOVES;      
        'Q' :QUITTER;
        'S' :STORE_GAME;
        'R' :RESTORE_GAME;
        'T' :DISPLAY_TIME;
        'G' :DISPLAY_MOVELOG;
        ELSE WRITELN('ERROR, INVALID COMMAND.');
    END;
END;

(****************)
(* MAIN PROGRAM *)
(****************)
BEGIN
    INIT_SQ_VALUES;
    INIT_BOARD;
    INIT_CONDITIONS;
    MOVE_TOTAL:=0;
    INTRODUCTION;
    GET_USERS_NAME;
    STATUS_CHECK;
    GAME_STAT:=1;
    PROGRAM_END_FLAG := FALSE;
    WHILE PROGRAM_END_FLAG = FALSE DO
         BEGIN
             DETERMINE_WINNER;
             IF PROGRAM_END_FLAG <> TRUE
               THEN PARSER;
         END;
    WRITELN;
    WRITELN('THANK YOU FOR PLAYING DEC OTHELLO.');
    WRITELN('GOOD BYE ',NAME);
    WRITELN;
END.
                                                                                                                         