$ !	REQUE.COM - requeues OPSER print entries to PBS.  Runs under
$ !		    batch control (in which case it resubmits itself
$ !		    to run an hour later ) or on
$ !		    demand for a user with WREAD privilege (to insure
$ !		    that the user has read access to all files to be
$ !		    printed).


$ !	Author:	Paul F. Flaherty, Jr.
$ !		DANIELS AND CRONIN
$ !		Three Center Plaza
$ !		Penthouse Mezzanine
$ !		Boston, Massachusetts   02108 USA


$ !	Check for WREAD privilege.  If not present then exit.

$ 	_if f$priv("WREAD") .nes. "" then _goto PRIVS_OK
$ _write 0 "?WREAD privilege required"
$ _exit

$ !	Close the initial log, if any.  Open a new log called Q.DAT, and make
$ !	it contain a full listing of the contents of LP0: queue.  Initialize
$ !	a couple of integer symbols.  Close Q.DAT, then reopen it for reading.
$ !	Set an simple error/warning trap.

$PRIVS_OK:

$ _close/log_file
$ _open/log_file/replace Q.DAT
$ _ccl Q/L
$ _close/log_file
$ POS = 0
$ POS1 = 0
$ _open/read 1 Q.DAT
$ _on warning then _goto ABBY_NORMAL

$ !	Read records from Q.DAT until either "IS EMPTY" or "/SE:" is found.
$ !	The former indicates nothing to do, the later indicates we've found
$ !	the first record in which we're interested.

$CHECK_FOR_NO_DATA:

$ _gosub READ_RECORD
$ POS = f$instr(1,QUE_DATA,"IS EMPTY")
$	_if POS .ne. 0 then _goto NO_MORE
$ POS = f$instr(1,QUE_DATA,"/SE:")
$	_if POS .ne. 0 then _goto GOT_ONE
$ _goto CHECK_FOR_NO_DATA

$ !	This is the main processing loop.  The first time through we've already
$ !	got a record so we skip to the GOT_ONE routine, but after the first
$ !	we go through here each time.   There are at least three records we
$ !	have to read for each queue entry.  We are interested in entry name,
$ !	owner and form name from the first record, nothing from the second
$ !	record, and from the third and possibly succeeding records, file names,
$ !	number of copies, and the delete switch.  Also, we check to see if the
$ !	file to be printed still exists, and if it doesn't we simply remov
$ !	OPSER queue entry and continue.

$MAIN_LOOP:

$ _gosub READ_RECORD
$ POS = f$instr(1,QUE_DATA,"/SE:")
$	_if POS .eq. 0 then _goto MAIN_LOOP

$GOT_ONE:

$ ENTRY = f$mid(QUE_DATA,3,POS-3)
$ POS = f$instr(1,QUE_DATA,"/FO:")
$	_if POS .eq. 0 then _goto ABBY_NORMAL
$ FORM_NAME = f$right(QUE_DATA,POS+4)
$ POS = f$instr(1,QUE_DATA,"[")
$ POS1 = f$instr(POS,QUE_DATA,"]")
$ OWNER = f$mid(QUE_DATA,POS,(POS1-POS)+1)
$ _read 1 QUE_DATA

$GET_FILE_NAMES:

$ _gosub READ_RECORD
$ QUE_DATA = f$edit(QUE_DATA,2)
$	_if QUE_DATA .eqs. "" then _goto MAIN_LOOP
$ COPIES = "1"
$ DELETE = ""
$ POS = f$instr(1,QUE_DATA,"/C:")
$ POS1 = f$instr(1,QUE_DATA,"/D")
$	_if POS1 .ne. 0 then DELETE = "/DELETE"
$	_if POS .eq. 0 then _goto DO_NAME_NOW
$ 	_if POS1 .ne. 0 then COPIES = f$mid(QUE_DATA,POS+3,((POS1-1)-(POS+2)))
$ 	_if POS1 .eq. 0 then COPIES = f$right(QUE_DATA,POS+3)

$DO_NAME_NOW:
$	_if POS .eq. 0 .and. POS1 .eq. 0 then FILE_NAME = QUE_DATA
$	_if POS1 .ne. 0 then FILE_NAME = f$left(QUE_DATA,POS1-1)
$ 	_if POS .ne. 0 then FILE_NAME = f$left(QUE_DATA,POS-1)
$	_if f$search(FILE_NAME) .eqs. "" then _goto FILE_NOT_FOUND
$ _print/form='FORM_NAME'/copies='COPIES'/owner='OWNER''DELETE' 'FILE_NAME'

$FILE_NOT_FOUND:

$ _ccl q/k 'ENTRY'
$ _goto GET_FILE_NAMES

$ !	Here is the subroutine where we do the actual read and reformat
$ !	of the records.

$READ_RECORD:

$ _read/end_of_file=NO_MORE 1 QUE_DATA
$ QUE_DATA = f$edit(QUE_DATA,444)
$ _return

$ !	General error trap.  Notify humans that an error occurred and append
$ !	Q.DAT to the message.  By comparing Q.DAT to the current state of the
$ !	LP0: queue, a good guess can be made as to where the error occurred
$ !	and how to recover.

$ABBY_NORMAL:

$ _on warning then _exit
$ _close/all
$ _open/write/replace 1 REQUE.ERR
$ _write 1 ""
$ _write 1 "==============> R E Q U E . C O M  E R R O R  L O G"
$ _write 1 "                ==================================="
$ _write 1 ""
$ _write 1 "An error or warning occurred while processing the following"
$ _write 1 "QUEUE listing in REQUE.COM.  Please have the system manager"
$ _write 1 "compare this listing with the current queue to determine"
$ _write 1 "recovery procedures."
$ _write 1 ""
$ _write 1 ""
$ _close 1
$ _append Q.DAT REQUE.ERR
$ _print REQUE.ERR

$ !	If running under PBS control resubmit to run again later, close file(s),
$ !	get rid of Q.DAT, and exit.


$NO_MORE:

$	_if f$access() .eqs. "BATCH" then _submit/after=+1HOUR PBS$:REQUE.COM
$ _close/all
$ _delete/noconfirm/nolog Q.DAT
$ _exit
                                                                                                                                                                                                                                                                                                                                                                                                                                                 