$! CLEAN.COM - Perform file housekeeping
$!
$! CLEAN is a utility that allows you to wade through your account, or
$! any account, file by file, and do something with the files: view them,
$! DELETE them, MOVE them somewhere else, or leave them alone.
$!
$! CLEAN allows you to specify a wildcard filespec in case you want to
$! limit the scope of your cleaning efforts to less than your whole
$! directory.
$!
$! If you invoke CLEAN with no parameters, you will be prompted for
$! a filespec.  If you invoke it with P1 = filespec then you won't be
$! prompted.  If you invoke it with P2 = filespec1 then the operations
$! with the P1 filespec will begin at the first occurrance of the P2
$! filespec1.  For example:
$!
$!		@CLEAN *.* TEST.TXT
$!
$! will allow you to examine and choose what to do with every file in your
$! current account starting with the file TEST.TXT.  This is so you can
$! continue from where you left off earlier.
$!
$! When you invoke CLEAN, it will display the filename of the first file
$! that matches your specified filespec.  It will then offer you some
$! choices:
$!
$!	B - (Backward)   Backs up to the preceding file
$!	F - (Forward)    Moves forward to next file (default)
$!	V - (View)       Displays file contents, one screen at a time.
$!	M - (Move)       Copies file to new location (and marks file for delete)
$!	D - (Delete)     Marks file for deletion on exit
$!	E - (Erase)      Marks file for erasure on exit
$!	X - (Exit)       Exits (after deleting/erasing any marked files)
$!
$! Typing CTRL/Z will exit the program without deleting or erasing any files.
$!
$! If type CTRL/C then the program will abort immediately; there will be two
$! .COM files left in your account -- JUNK1.TMP, which is used for lower level
$! searches, and JUNK2.TMP, which is the delete/erase list .COM file.
$!
$! NOTE:  This program has been used for some time and appears to work, but
$! it has not had wide distribution or testing, and there may be unforseen
$! problems.  Please take care in its use, and realize that you are using
$! it at your own risk.
$!
$!-------------------------------------------------------------------------
$! Init environment
$
$ _set echo
$ _set noverify
$ _set control=c
$
$!-------------------------------------------------------------------------
$! Define some handy commands
$
$ tell  := write 0
$ skip  := write 0 """"""
$
$!-------------------------------------------------------------------------
$! Define some procedure symbols
$
$ esc = f$chr(27)
$ clear_scr = esc + "[H" + esc + "[2J"
$
$ deletes := FALSE
$
$!-------------------------------------------------------------------------
$! Generate a .com file for secondary searches
$
$ tell/nodelimiter "Working..."
$ 
$ _close 1
$ _open/write/replace 1 junk1.tmp
$ _write 1 "$ exist == (f$search(""''p1'"") .nes. """")"
$ _write 1 "$ _exit"
$ _close 1
$ 
$!-------------------------------------------------------------------------
$! Create a .com file for deletions/erasures on exit
$
$ _close 2
$ _open/write/replace 2 junk2.tmp
$
$!-------------------------------------------------------------------------
$! Display options screen
$
$ _on error then goto error
$
$ skip
$ skip
$ tell "(B)ackward   Back up to the previous file"
$ tell "(F)orward    Move forward to next file (default)"
$ tell "(V)iew       Display contents of current file"
$ tell "(M)ove       Copy file, then mark it for delete"
$ tell "(D)elete     Mark file for delete"
$ tell "(E)xit       Exit after deleting marked files"
$ tell "CTRL/Z       Exit without deleting marked files"
$ tell "CTRL/C       Abort immediately"
$
$ skip
$ _inquire/nopunc/exit=exit junk "Press RETURN to continue..."
$ 
$ skip
$ _if p1 .eqs. "" then _inq/nopunc/exit=exit p1 "File: "
$ _if p2 .nes. "" then p2 = f$search(p2)
$ oldp1=p1
$ file=""
$
$!-------------------------------------------------------------------------
$! Get next matching file
$
$ search:
$ _on error then _goto exit
$ tell "''clear_scr'"
$ oldfile = file
$ file = f$search(p1)
$ p1 = ""
$ _if f$parse(file,,"TYPE") .eqs. ".TMP" then -
	_if f$parse(file,,"JUNK1") .or. f$parse(file,,"JUNK2") then -
		_goto search
$ _if p2 .nes. "" then _gosub init
$ _if file .eqs. "" then _goto exit
$ _directory 'file'/full
$ doit = "read"
$ goto ask
$
$!-------------------------------------------------------------------------
$! VIEW handler
$ 
$ view:
$ _on error then _goto ask
$ skip
$ skip
$ _close 1
$ _close 1
$ _open/read 1 'file'
$ doit = "count"
$ count:
$ count=0
!$ write/nodel 0 f$chr(27),"[A",f$chr(27),"[K"	!!! use scrolling region?
!$ write/nodel 0 f$chr(27),"[A",f$chr(27),"[K"
$ loop:
$ _read/end=end 1 record
$ tell record
$ count = count + 1
$ _if count .lt. 22 then _goto loop
 
$ ask:
$ _on error then _goto ask
$ skip
$ tell/nodelimiter file
$ _inquire/exit=exit junk " (B)ack, (N)ext, (T)ype, (M)ove, (D)elete, (E)xit, <Next>"
$ junk = f$edit(junk,-1)
$ _if junk .eqs. "" then _goto search
$ _if junk .eqs. "B" then _goto back
$ _if junk .eqs. "M" then _goto move
$ _if junk .eqs. "D" then _goto delete
$ _if junk .eqs. "T" then _goto 'doit'
$ _if junk .eqs. "E" then _goto cleanup
$ _goto ask
 
$ back:
$ _close 1
$ p1 = oldp1
$ p2 = oldfile
$ _goto search
 
$ move:
$ _close 1
$ defnam = f$parse(file,,"name") + f$parse(file,,"type")
$ _inquire/exit=exit to "Move file to ( [Dev] [Acc] [Filename] ) <cancel move>"
$ flag = f$parse(to,,"flags")
$ _if flag .eq. 0 then _goto ask
$	! No filespec typed
$ if flag .eq. -1 then write 0 "Invalid file spec"
$ if flag .eq. -1 then goto move
$	! invalid file spec
$ if (flag .and. 17) .eq. 0 then TO = TO + defnam
$ 	! if they didn't specify a filename, then use default from 'file'
$ @clean1 'TO'
$ if exist .eqs. "F" then goto move1
$ write/nodel 0 "Overwrite ''TO' (Y/N) <N>?"
$ inquire/nopunc/exit=exit YN ""
$ if YN .eqs. "" then YN = "N"
$ YN = f$edit(YN,-2)
$ if f$left(YN,1) .nes. "Y" then goto ask
 
$ move1:
$ tell/nodelimiter "Working..."
$ _set nodata
$ _copy/replace/nolog 'file' 'to'
$ _set data
 
$ delete:
$ _close 1
$ _write 2 "_delete/nowarn/nolog ''file'"
$ deletes := TRUE
$ skip
$ _goto search
 
$ end:
$ doit="view"
$ goto ask
 
$init:
$ if p2 .eqs. file then goto wuff
$ oldfile=file
$ file = f$search()
$ goto init
$wuff:
$ p2 = ""
$ return
 
$ error:
$ inquire/nopunc/exit=exit junk "Press RETURN to continue..."
$ goto ask
 
$ cleanup:
$ tell/nodelimiter "Deleting files..."
$ _close 1
$ _close 2
$ @junk2.tmp
$ _delete/nolog/nowarn junk1.tmp
$ _delete/nolog/nowarn junk2.tmp
 
$!-------------------------------------------------------------------------
$! Exit procedure
$
$ exit:
$ skip
$ _exit
                                                                                                                                                                                                                                                                                                                           