/*

	*****************************************
	*					*
	*	Brian D. Lockrey		*
	*	ITT North Technology Center	*
	*	4565 Columbus Pike		*
	*	Delaware, Ohio 43015		*
	*	614-548-4301 Ext. 343		*
	*					*
	*****************************************

	Release	2.01

		S P E L L

	Description:

		Checks a documentation file for spelling errors.

	Entry Points:

		MAIN	- the only entry point

	External Routines:

		EDITS	- EDIT$ string function
		ERRTXT	- Return RSTS/E Error text
		GETSTR	- Get a string from a channel
		HEADER	- Print Header Text
		RMSCLO	- RMS Close a file
		RMSCON	- RMS Connect a Record Access Stream
		RMSFND	- RMS Find a Record
		RMSKEY	- RMS Specify Key of Reference
		RMSOPE	- RMS Open a file
		RMSRAC	- RMS Specify Record Access mode

	Change Activities:

	Date		Pgm-#	Description
	----		-----	-----------
	08-Jan-82	2.01	Original Release

*/

#include	<stdio.h>
extern int rmsope(), rmscon(), rmskey();
extern int rmsfnd(), rmsrac(), rmsclo();

char *buf;
char file5[30], recbuf[24], keybuf[24];
char word[50];

int lun, fac, shr, istat, keynum, keysiz, mode, recsiz, rop;
int next, full;
int rfa[3];

struct link {
	int data;
	int left;
	int right;
}
struct link *list;

FILE *f1;

main(argc, argv)
char *argv[];
int argc;
{
	char c;
	int i, w;

	header("SPELL Version 2.01");
	buf = alloc(256);	/* char buf[256] */
	list = alloc(6000);
	for (i=0; i<1000; ++i) {
		list[i].data = 0;
		list[i].left = 0;
		list[i].right = 0;
	}
	next = 0;
	full = FALSE;

l0:	puts("Input File? ");
	gets(buf);
	if ((f1 = fopen(buf,"r")) == NULL) {
		puts("?Open failure for input file\n");
		goto l0;
	}
	lun = 5;	/* primary dictionary */
	strcpy(file5,"C:SPDICT.DAT");
	fac = 0;
	shr = 1;	/* allow shared access */
	call (rmsope,5,&lun,&file5,&fac,&shr,&istat);
	if (istat != 1) {
		puts("%Open failure for dictionary file\n");
		rmserr();
	}
	keynum = 0;
	mode = 1;
	recsiz = 24;
	call (rmscon,6,&lun,&keynum,&mode,&recbuf,&recsiz,&istat);
	if (istat != 1) rmserr();
	call (rmsrac,3,&lun,&mode,&istat);
	if (istat != 1) rmserr();
	rop = 0;	/* .eq. */
	keysiz = 24;
	call (rmskey,6,&lun,&keynum,&keybuf,&keysiz,&rop,&istat);
	if (istat != 1) rmserr();
	w = 0;
	while (getstr(f1,buf) != EOF) {
		fold(buf);
		edits(buf,28);
		i = 0;
		while (buf[i] != '\0') {
			c = buf[i++];
			if (c == '-' && buf[i] != '\0') c = ' ';
			if (c != ' ' && c != '-') word[w++] = c;
			if (c == ' ') {
				word[w] = '\0';
				lookup(word);
				w = 0;
			}
		}
		if (c != '-') {
			word[w] = '\0';
			lookup(word);
			w = 0;
		}
	}
	fclose(f1);
	call (rmsclo,2,&lun,&istat);
	if (istat != 1) rmserr();
}
	
lookup(str)
char *str;
{
	int i;

	if (strlen(str) < 3) return;
	if (intable(str) == TRUE) {
		return;
	}
	for (i=0; i<24; ++i) {
		keybuf[i] = ' ';
	}
	for (i=0; str[i] != '\0'; ++i) {
		keybuf[i] = str[i];
	}
	install(str);
	call (rmsfnd,3,&lun,&rfa,&istat);
	if (istat == 1) return;
	if (istat == -1472) {
		printf("==> %s\n", str);
		return;
	}
	rmserr();
}

rmserr()
{
	printf("?RMS error code: %d\n", istat);
	exit(1);
}

fold(s)
char s[];
{
	int i,t;

	i = 0;
	while (s[i] != 0) {
		s[i] = valid(s[i]);
		++i;
	}
}

valid(c)
char c;
{
	if (c >= 'a' && c <= 'z') return(c);
	if (c >= 'A' && c <= 'Z') return(c+32);
	if (c == '-') return(c);
	return(' ');
}

puts(str)
char *str;
{
	char c;
	while ((c = *str) != 0) {
		putchar(c);
		++str;
	}
}

install(str)
char *str;
{
	int root, last, t, leg;

	if (full == TRUE) return;
	if (next == 0) {
		t = alloc(strlen(str)+1);
		++next;
		list[next].data = t;
		strcpy(t,str);
		return;
	}
	root = 1;
	for (;;) {
		t = strcmp(str,list[root].data);
		last = root;
		switch (t) {
			case -1: root = list[root].left;
				leg = 0;
				break;
			case 0: return;
			case 1:	root = list[root].right;
				leg = 1;
				break;
		}
		if (root == 0) {
			t = alloc(strlen(str)+1);
			if (t == -1) {
				full = TRUE;
				return;
			}
			++next;
			list[next].data = t;
			if (next >= 999) {
				full = TRUE;
				return;
			}
			strcpy(t,str);
			switch (leg) {
				case 0:	list[last].left = next;
					return;
				case 1: list[last].right = next;
					return;
			}
		}
	}
}

intable(str)
char *str;
{
	int root, t;

	root = 1;
	for (;;) {
		t = strcmp(str,list[root].data);
		switch (t) {
			case -1: root = list[root].left; break;
			case 0: return(TRUE); break;
			case 1:	root = list[root].right; break;
		}
		if (root == 0) return(FALSE);
	}
}

