/*

	*****************************************
	*					*
	*	Brian D. Lockrey		*
	*	ITT North Technology Center	*
	*	4565 Columbus Pike		*
	*	Delaware, Ohio 43015		*
	*	614-548-4301 Ext. 343		*
	*					*
	*****************************************

	Release	2.01

		S P L M O D

	Description:

		SPELL Dictionary Modifier

	Entry Points:

		MAIN	- the only entry point

	External Routines:

		ERRTXT	- Return RSTS/E Error text
		FOLD	- Convert string to lower case
		HEADER	- Print Header Text
		RMSCLO	- RMS Close a file
		RMSCON	- RMS Connect a Record Access Stream
		RMSDEL	- RMS Delete a Record
		RMSFND	- RMS Find a Record
		RMSGET	- RMS Get a Record
		RMSKEY	- RMS Specify Key of Reference
		RMSOPE	- RMS Open a file
		RMSPUT	- RMS Put a Record
		RMSRAC	- RMS Specify Record Access mode
		UPPER	- Cinvert character to upper case

	Change Activities:

	Date		Pgm-#	Description
	----		-----	-----------
	08-Jan-82	2.01	Original Release

*/

#include	<stdio.h>
extern int rmsope(), rmscon(), rmskey();
extern int rmsfnd(), rmsrac(), rmsclo();
extern int rmsget(), rmsput(), rmsdel();

char *buf;
char file5[30], recbuf[25], keybuf[25];
char word[50];

int lun, fac, shr, istat, keynum, keysiz, mode, recsiz, rop;
int rfa[3];
FILE *f1;

main(argc, argv)
char *argv[];
int argc;
{
	char c;
	int i, w;

	header("SPLMOD Version 2.01");
	buf = alloc(256);	/* char buf[256] */

	lun = 5;	/* primary dictionary */
	fac = 3;	/* write access */
	shr = 0;	/* no sharing */
	keynum = 0;	/* key # 0 */
	rop = 0;	/* .eq. match */
	mode = 1;	/* random (key) */
	recsiz = 24;	/* recordsize */
	keysiz = 24;	/* keysize */

	strcpy(file5,"C:SPDICT.DAT");
	call (rmsope,5,&lun,&file5,&fac,&shr,&istat);
	if (istat != 1) {
		puts("%Open failure for dictionary file: ");
		puts(file5); puts("\n");
		rmserr();
	}
	call (rmscon,6,&lun,&keynum,&mode,&recbuf,&recsiz,&istat);
	if (istat != 1) rmserr();
	call (rmsrac,3,&lun,&mode,&istat);
	if (istat != 1) rmserr();
	call (rmskey,6,&lun,&keynum,&keybuf,&keysiz,&rop,&istat);
	if (istat != 1) rmserr();
	help();
	docmd();
	call (rmsclo,2,&lun,&istat);
	if (istat != 1) rmserr();
}

docmd()
{
	char c;

	for (;;) {
		puts("\n");
		puts("Command? ");
		gets(buf);
		c = upper(buf[0]);
		switch (c) {
			case 'A': spadd();
				  break;
			case 'D': spdel();
				  break;
			case 'F': spfnd();
				  break;
			case 'H': help();
				  break;
			case 'E': return;
			default:  puts("%Illegal command\n");
				  help();
				  break;
		}
	}
}

help()
{
	puts("\nValid commands are:\n\n");
	puts("  A  -  Add a word\n");
	puts("  D  -  Delete a word\n");
	puts("  E  -  Exit program\n");
	puts("  F  -  Find a word\n");
	puts("  H  -  Help\n");
}

spadd()
{
	int i;

	getword();
	setkey(word);
	for (i=0; i<24; ++i) {
		recbuf[i] = keybuf[i];
	}
	call (rmsput,3,&lun,&rfa,&istat);
	if (istat == 1) {
		printf("Added word: %s\n", word);
		return;
	}
	if (istat == -544) {
		printf("Word already exists: %s\n", word);
		return;
	}
	rmserr();
}

spdel()
{
	getword();
	setkey(word);
	call (rmsfnd,3,&lun,&rfa,&istat);
	if (istat == 1) {
		call (rmsdel,2,&lun,&istat);
		if (istat == 1) {
			printf("Deleted word: %s\n", word);
			return;
		}
		rmserr();
	}
	if (istat == -1472) {
		printf("Can't find word: %s\n",word);
		return;
	}
	rmserr();
}

spfnd()
{
	getword();
	setkey(word);
	call (rmsfnd,3,&lun,&rfa,&istat);
	if (istat == 1) {
		printf("Found word: %s\n", word);
		return;
	}
	if (istat == -1472) {
		printf("Can't find word: %s\n", word);
		return;
	}
	rmserr();
}

getword()
{
	puts("Word? ");
	gets(buf);
	buf[24] = '\0';
	strcpy(word,buf);
	fold(word);
}

rmserr()
{
	printf("?RMS error code: %d\n", istat);
	exit(1);
}

puts(str)
char *str;
{
	char c;
	while ((c = *str) != 0) {
		putchar(c);
		++str;
	}
}

setkey(str)
char *str;
{
	int i;

	for (i=0; i<24; ++i) {
		keybuf[i] = ' ';
	}
	for (i=0; str[i] != '\0'; ++i) {
		keybuf[i] = str[i];
	}
}
