      PROGRAM CCA4
C BENCHMARK CCA4, GAMMFD
C  GAMM IN FORTRAN  - DOUBLE PRECISION VERSION, VERSION 2
C NATIONAL PHYSICAL LABORATORY BENCHMARK GAMMFD
C-------------------------------------------------------------
C MODIFIED FOR AUTOMATIC TIMING OF BENCHMARK
C  USER  SHALL MODIFY THIS PROGRAM IN THE AREAS INDICATED
C TO PROVIDE AUTOMATIC TIMING. (SEE BELOW)
C SET LOGICAL UNITS 6 AND 7 TO A PRINTING DEVICE
C THIS BENCHMARK NEED ONLY BE RUN ONCE.
C--------------------------------------------------------
C THIS PROGRAM HAS A SINGLE PARAMETER N
C SET N = 3500 FOR ABOUT ONE MINUTE ON MACHINE LIKE 360/65
      INTEGER I, J, REP, THIRTY, TEN, FIVE, N
      DOUBLE PRECISION ACC, ACC1, DIVN, RN, Y, ROOT, X, A, B, C
      DIMENSION A(30), B(30), C(30)
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "STIME" TO A REFERENCE TIME
C IN SECONDS (ACCURATE TO AT LEAST ONE SECOND).
C-------------------------------------------------------------
        STIME=SECNDS(0.0)
      N = 3500
      FIVE = 5
      TEN = 10
      THIRTY = 30
      RN = N
      DIVN = 1.0 / RN
      X = .1D0
      ACC = 0.0
C         INITIALISE A AND B
      Y = 1.0
      DO 1 I= 1, 30
      A(I) = I
      B(I) = - Y
      Y = - Y
1     CONTINUE
      DO 15 REP = 1, N
C            ONE PASS OF THIS LOOP CORRESPONDS TO 300 GAMM UNITS
      I = 30
      DO 2 J = 1, THIRTY
         C(I) = A(I) + B(I)
      I = I - 1
2     CONTINUE
      Y = 0.0
      DO 3 I = 1, TEN
         Y = (Y + C(I)) * X
3     CONTINUE
      ACC1 =  Y * DIVN
      Y = C(11)
      DO 4 I = 12, 20
         IF (C(I) .GT. Y)  Y = C(I)
4     CONTINUE
      ROOT = 1.0
      DO 5 I = 1, 5
         ROOT = 0.5D0 * (ROOT + Y/ROOT)
5     CONTINUE
      ACC1 = ACC1 + ROOT * DIVN
      DO 6 I = 1, THIRTY
         A(I) = C(I) - B(I)
6     CONTINUE
      Y = 0.0
      DO 7 I = 1, TEN
         Y = (Y + A(I)) * X
7     CONTINUE
      ROOT = 1.0
      DO 8 I = 1, FIVE
         ROOT = 0.5D0 * (ROOT + Y/ROOT)
8     CONTINUE
      ACC1 = ACC1 + ROOT * DIVN
      DO 9 I = 1, THIRTY
         C(I) = C(I) * B(I)
9     CONTINUE
      Y = C(20)
      DO 10 I = 21, THIRTY
         IF (C(I) .GT. Y)  Y = C(I)
10    CONTINUE
      ROOT = 1.0
      DO 11 I = 1, 5
         ROOT = 0.5D0 * (ROOT + Y/ROOT)
11    CONTINUE
      ACC1 = ACC1 + ROOT * DIVN
      Y = 0.0
      DO 12 I = 1, TEN
         Y = (Y + C(I)) * X
12    CONTINUE
      ACC1 = ACC1 + Y * DIVN
      Y = C(1)
      DO 13 I = 2, TEN
         IF (C(I) .GT. Y)  Y = C(I)
13    CONTINUE
      ROOT = 1.0
      DO 14 I = 1, FIVE
         ROOT = 0.5D0 * (ROOT + Y/ROOT)
14    CONTINUE
      ACC1 = ACC1 + ROOT * DIVN
      ACC = ACC + ACC1
15    CONTINUE
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "TTIME" TO TOTAL AMOUNT OF
C ELAPSED TIME SINCE "STIME" IN SECONDS.
C-------------------------------------------------------------
        TTIME=SECNDS(STIME)
      WRITE( 6, 100) N, ACC, ACC1
C SHOULD PRINT N THEN 16.73343 22410 90064 71684 80142
C                        13037 73134 63994
100   FORMAT( I10, 2D40.30 )
C--------------------------------------------------------------
C LLL MODIFICATION TO PRINT TOTAL ELAPSED TIME OF BENCHMARK
      TTIME = TTIME/60.0
      WRITE(6,1000)TTIME
1000  FORMAT(' BENCHMARK 4 EXECUTION TIME IS ',F8.4,' MINUTES')
C--------------------------------------------------------------
      STOP
      END
                                         