#define	NCHAN	16

#define	BLKSIZB	512
#define	BLKSIZW	(BLKSIZB/2)

struct {
	int	size;
	int	blk;
} _fblk[NCHAN];


open(file,mode)
char	*file;
char	*mode;
{
	int	chan;

	if ( (chan=_getchn()) < 0 || chan >= NCHAN )
		return(-1);
	if ( (_fblk[chan].size=_lookup(chan,file)) < 0 )
		return(-1);
	_fblk[chan].blk = 0;
	return(chan);
}


lseek(chan,offset,whence)
register int	chan;
register long	offset;
int		whence;
{
	int	boffset;
	int	pos;

	if ( offset%BLKSIZB != 0L )
		return(-1);
	boffset = offset/BLKSIZB;
	switch ( whence ) {
	case 0: pos = boffset; break;
	case 1: pos += boffset; break;
	case 2: pos = _fblk[chan].size - boffset; break;
	default:	return(-1);
	}
	if ( pos < 0 )
		return(-1);
	_fblk[chan].blk = pos;
	return(BLKSIZB*pos);
}


read(chan,buf,nbytes)
int	chan;
char	*buf;
int	nbytes;
{
	int	nwords;

	if ( nbytes%BLKSIZB != 0 )
		return(-1);
	if ( (nwords=_readw(chan,buf,nbytes/2,_fblk[chan].blk)) <= 0 )
		return(nwords);
	_fblk[chan].blk += nwords/BLKSIZW;
	return(2*nwords);
}


close(chan)
int	chan;
{
	_close(chan);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                    