/* naminit.c - naminit */

#include <conf.h>
#include <kernel.h>
#include <name.h>

#ifndef	RFILSYS
#define	RFILSYS	SYSERR
#endif
#ifdef	Nnsys
struct	nam	Nam;
#endif

/*------------------------------------------------------------------------
 *  naminit  -  initialize the syntactic namespace pseudo-device
 *------------------------------------------------------------------------
 */
naminit()
{
	Nam.nnames = 0;

	/* Xinu namespace definition */

	mount("",		NAMESPACE, "Xinu/storage/");
	mount("Xinu/",		RFILSYS,   "/usr/Xinu/");
	mount("h/",		NAMESPACE, "Xinu/src/serve11/h/");
	mount("kernel/",	NAMESPACE, "Xinu/src/serve11/sys/");
	mount("core11",		NAMESPACE, "kernel/core11");
	mount("a.out",		NAMESPACE, "kernel/serve11");
	mount("/dev/console",	CONSOLE,   NULLSTR);
	mount("/dev/null",	RFILSYS,   "/dev/null");
	mount("/dev/",		SYSERR,    NULLSTR);
	mount("/",		RFILSYS,   "/");
	mount("~/",		NAMESPACE, "Xinu/");
}
