/*
    Copyright (c) 2013, Henk Stegeman

    This program takes the binary image of an SIMH .TAP output file
    and converts it to a flat disk file in IBM 5444 format for the
    System/3 Simulator.  It works on DTR tapes.

    Usage:  tap2dsk awstapefile diskfile
 */

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define FLPSIZ 65536

struct AWSTAPE_BLKHDR {
        char    curblkl[4];             /* Length of this block      */
        char    prvblkl[4];             /* Length of previous block  */
    } awshdr;

int main (int argc, char *argv[])
{
int i, k, wc, fcount, recs = 0;
int prevsize = 1, min = 65535, max = 0;
int skiptape = 0, stopeof = 0, verbose = 0, ac = 1;
unsigned char bc[4] = { 0 };
unsigned char word[2] = { 0 };
unsigned char word2[2] = { 0 };
unsigned char buf[FLPSIZ];
unsigned char zeros[FLPSIZ];
FILE *ifile, *ofile;

   for (i = 0; i < FLPSIZ; i++) {  /* init with zeros */
      zeros[i] = 0;
   }

   if ((argc < 3) || (argv[0] == NULL)) {
      printf ("Usage: tap2dsk [-v] [-e] taptapefile simdiskfile\n");
      printf ("    -v = Verbose, print size of every block\n");
      printf ("    -e = Stop converting when double tapemark found\n");
      printf ("        -15 = DTR tape is for a model 15\n");

      exit (0);
   }

   ac = 1;
   while (1) {
      if (strcmp(argv[ac], "-v") == 0) {
         verbose = 1;
         ac++;
         continue;
      }
      if (strcmp(argv[ac], "-e") == 0) {
         stopeof = 1;
         ac++;
         continue;
      }
      if (strcmp(argv[ac], "-15") == 0) {
         skiptape = 8;
         ac++;
         continue;
      }


      ifile = fopen (argv[ac], "rb");
      if (ifile == NULL) {
         printf ("Error opening input file: %s\n", argv[ac]);
         exit (0);
      }

      ac++;
      ofile = fopen (argv[ac], "wb");
      if (ofile == NULL) {
         printf ("Error opening output file: %s\n", argv[ac]);
         exit (0);
      }
      break;
   }

   fcount = recs = max = 0;
   min = 65535;
   printf("\nCopying file %d...", fcount);

   while (1) {
      if (stopeof > 1)
         break;
      k = fread (word, sizeof (char), 2, ifile);
      if (k == 0) break;
      k = fread (word2, sizeof (char), 2, ifile);
      if (k == 0) break;

      wc = ((unsigned int) word[1] << 8) | (unsigned int) word[0];
      if (wc == 0) {      /* Special EOF mark */
         if (recs > 0) {
            printf("\nProcessed: %d blocks, min %d, max %d\n", recs, min, max);
         } else {
            printf("\n(Empty)");
            if (stopeof == 1 && prevsize == 0)
               stopeof = 2;
         }
         fcount++;
         prevsize = recs;
         recs = max = 0;
         min = 65535;
         if (stopeof < 2)
            printf("\nCopying file %d...", fcount);
         continue;
      }

      if (wc > max) max = wc;
      if (wc < min) min = wc;
      recs++;
      if (verbose)
         printf("\nRecord %d, %d bytes", recs, wc);
      wc = (wc + 1) & ~1;
      bc[0] = word[0];
      bc[1] = word[1];

      if (wc) {
         k = fread (buf, sizeof (char), wc, ifile); /* Read rec from tape */
         for ( ; k < wc; k++)
            buf[k] = 0;
         if (recs == (6 + skiptape)) {
            /* Write 3 cylinders of zeros (alternate tracks) */
            fwrite (zeros, sizeof(char), 12288, ofile);
            fwrite (zeros, sizeof(char), 12288, ofile);
            fwrite (zeros, sizeof(char), 12288, ofile);
         }
         if (recs > (1 + skiptape)) { /* Skip 1st block or 9 blocks */
            fwrite (buf+2, sizeof(char), wc-2, ofile);
            printf("\nWriting record %d to disk", recs);
         }
         /* Skip length count at the end of the record */
         fread (word2, sizeof (char), 2, ifile);
         fread (word2, sizeof (char), 2, ifile);
      }
   }

   if (recs > 0)
      printf("\nProcessed: %d blocks, min %d, max %d\n", recs, min, max);
   else
      printf("\n(Empty)");

   printf("\nEnd of Tape\n");

   fwrite (zeros, sizeof(char), 12288, ofile);   /* Write CE Track */
   fclose (ifile);
   fclose (ofile);
   return (0);
}
