// Copyright (C) UnalZ, 2003
// Runstream (R) MicroChannel Port Driver, NT 3.51 DDK
//---------------------------------------------------------------------------
// mcpread.c	Reads POS bytes
//
// MCPOS Driver test routine
//
//---------------------------------------------------------------------------
// UnalZ, Runstream
//		Sep 2002 -- created but not yet tested
//		Dec 2002 -- moved to DDK 4.0, tested
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <winioctl.h>
#include "mcpioctl.h"


void
__cdecl
main(
    IN int  argc,
    IN char *argv[]
    )

{

    HANDLE  hDriver;
    BOOL    ioStatus;
    USHORT	slotNumber;
    UCHAR	posBytes[MCP_MAX_POS*2];
    DWORD   returnedCount;

    // input buffer is the USHORT slot nnumber
    // output buffer is the UCHAR array for the pos bytes
    // the device is \\\\.\\MCPOS

    hDriver = CreateFile(
                MCPOS_DEVICE_NAME,
                GENERIC_READ,
                FILE_SHARE_READ,
                NULL,
                OPEN_EXISTING,
                0,
                NULL
                );

    if (hDriver == INVALID_HANDLE_VALUE)
    {
        printf("Unable to open MCPOS device.\n");
        exit(1);
    }

	// loop through the slots now

	for(slotNumber = 1; slotNumber <= MCP_MAX_SLOT; slotNumber++)
	{
		ioStatus = DeviceIoControl(
							hDriver,            	// Handle to device
							IOCTL_MCP_READ_SLOT,	// IO Control code for Read
							&slotNumber,        	// Buffer to driver.
							sizeof(slotNumber),		// Length of buffer in bytes.
							posBytes,				// Buffer from driver.
							sizeof(posBytes),		// Length of buffer in bytes.
							&returnedCount,			// Bytes placed in output buffer
							NULL                	// NULL means wait till op. completes.
							);
		if (ioStatus)
		{
			printf("\nSLOT %d : Adapter ID =  %02X%02X   ",
					slotNumber,
					posBytes[1],
					posBytes[0]
					);

			if ( posBytes[0] == 0xFF && posBytes[1] == 0xFF)
			{
				printf("** EMPTY **");
			}

			printf("\n102 = %02X  103 = %02X  104 = %02X  105 = %02X  (106 = %02X  107 = %02X)\n",
					posBytes[2], posBytes[3],
					posBytes[4], posBytes[5],
					posBytes[6], posBytes[7]
					);
		}
		else
		{
			printf("Slot = %d : Read POS failed with code %ld\n",
					slotNumber,
					GetLastError()
					);
		}
	}


	// read planar id /////////////////////////////////////////////

	ioStatus = DeviceIoControl(
						hDriver,            	// Handle to device
						IOCTL_MCP_READ_PLANAR,	// IO Control code for Read
						NULL,					// no input params
						0,						// input param length 0
						posBytes,				// Buffer from driver.
						sizeof(posBytes),		// Length of buffer in bytes.
						&returnedCount,			// Bytes placed in output buffer
						NULL                	// NULL means wait till op. completes.
						);

	if (ioStatus)
	{
		printf("\n\nPLANAR ID = %0X%0X\n",
				posBytes[1],
				posBytes[0]
				);
	}
	else
	{
		printf("Read Planar ID failed with code %ld\n",
				GetLastError()
				);
	}


	// close the device //////////////////////////////

    if (!CloseHandle(hDriver))
    {
        printf("Failed to close device.\n");
    }

    printf("\n------------------------------------------------------\
            \nRunstream (R) MCPOS Windows NT Driver, Beta Rel. 00.02\
            \nCopyright (C) Unal Z, 2002. All rights reserved. #0212\n");


    exit(0);

} /* main */


///// End of code //////////////////////////////////////////////////
