// Runstream (R) MicroChannel Port Driver, Windows NT 4.0 DDK
// Copyright (C) UnalZ, 2002
//---------------------------------------------------------------------------
// mcpwrite.c	Write to LED display
//
// MCPOS Driver test routine
//
//---------------------------------------------------------------------------
// UnalZ, Runstream
//		Sep 2002 -- created but not yet tested
//		Dec 2002 -- moved to DDK 4.0, tested
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <winioctl.h>
#include "mcpioctl.h"

#define MCP_DEBUG
#undef MCP_DEBUG

// computer name
#define MACHINE_NAME_LEN    MAX_COMPUTERNAME_LENGTH + 2
#define MACHINE_NAME_SIZE   MACHINE_NAME_LEN + 1

// io success
#define	IO_SUCCESS	0
#define	IO_FAILURE	-1

// function prototypes

DWORD
WriteLED(
	IN HANDLE,
	IN UCHAR,
	IN PUCHAR,
	IN BOOL
	);

DWORD
WriteComputerName(
	IN HANDLE
	);


///////////////////////////////////////////////////////////////////////

DWORD
WriteLED(
	HANDLE 		hDriver,
	IN UCHAR	cellNo,
	IN PUCHAR	textOut,
	IN BOOL		clearScr
	)

/*
 * Write to the LED display. The leftmost cell is numbered as 1,
 * the rightmost cell as 8. The driver intercepts invalid values
 * and right trims the text when necessary.
 *
 * in :	hDriver	= MCPOS driver handle
 *		cellNo	= starting cell (x-coord) for output
 *		textOut	= output text
 *		clearScr= set to true if display must be cleared
 *
 *
 */

{
	DWORD   		returnedCount;
	BOOL    		ioStatus;
	SHORT			outTextLen;
	USHORT			textLen;
	USHORT			i;
	MCP_LED_DISPLAY	ledLine;


	// check cellNo

	if ( cellNo < 1 || cellNo > MCP_MAX_LED )
	{
		return IO_FAILURE;
	}

	// calculate text length
	textLen = strlen(textOut);

	// trim the text length if it is too long

	outTextLen = textLen + cellNo - 1;

	if ( outTextLen > MCP_MAX_LED )
	{
		textLen = MCP_MAX_LED - cellNo + 1;
	}

	// create input buffer to driver

    if ( clearScr )
    {
		strcpy(ledLine.Text, MCP_BLANK_LED);

		// copy text to input buffer
		for (i = 0; i < textLen; i++)
		{
			ledLine.Text[i + cellNo - 1] = textOut[i];
		}

		// full display update
		ledLine.Position = 1;
		ledLine.TextLength = MCP_MAX_LED;

	}
	else
	{
		strcpy(ledLine.Text, textOut);
		ledLine.Position = cellNo;
		ledLine.TextLength = (UCHAR)textLen;
	}


#ifdef MCP_DEBUG
printf("\nDEBUG: Cell: %d  Len: %d   Text: [%s]\n", cellNo, textLen, ledLine.Text);
#endif


	// call the driver
	ioStatus = DeviceIoControl(
						hDriver,            	// Handle to device
						IOCTL_MCP_WRITE_LED,	// IO Control code for write LED
						&ledLine,        		// Buffer to driver.
						sizeof(ledLine),		// Length of buffer in bytes.
						&ledLine,				// * not used: Buffer from driver.
						sizeof(ledLine),		// * not used: Length of buffer in bytes.
						&returnedCount,			// * not used: Bytes placed in output buffer
						NULL                	// NULL means wait till operation completes.
						);

	if (!ioStatus)
	{
		return	GetLastError();
	}

	return IO_SUCCESS;

} /* write to LED */

///////////////////////////////////////////////////////////////////////

DWORD
WriteComputerName(
	IN HANDLE 		hDriver
	)

/*
 * Write computer name to the LED display
 *
 * in :	hDriver	= MCPOS driver handle
 *
 */

{
	TCHAR   mName[MACHINE_NAME_SIZE];
	DWORD   mnSize = MACHINE_NAME_SIZE;

	GetComputerName(mName, &mnSize);

	return WriteLED(hDriver, 1, mName, 1);


} /* write computer name */

///////////////////////////////////////////////////////////////

void
__cdecl
main(
    IN int  argc,
    IN char *argv[]
    )

{

    HANDLE 	hDriver;
    DWORD	ioStatus;

    // create device file

    hDriver = CreateFile(
                MCPOS_DEVICE_NAME,
                GENERIC_READ,
                FILE_SHARE_READ,
                NULL,
                OPEN_EXISTING,
                0,
                NULL
                );

    if (hDriver == INVALID_HANDLE_VALUE)
    {
        printf("Unable to open MCPOS device.\n");
        exit(1);
    }

	// D I S P L A Y demo routines //////////////////////////////

	// write computer name


	ioStatus = WriteComputerName(hDriver);

	if (ioStatus != IO_SUCCESS)
	{
		printf("Write LED failed with code %ld\n",
				ioStatus
				);
	}


	// write arbitrary string

/**
	ioStatus = WriteLED(hDriver, 1, "PS/2MCA", 1);


	if (ioStatus != IO_SUCCESS)
	{
		printf("Write LED failed with code %ld\n",
				ioStatus
				);
	}

**/
	// close the device //////////////////////////////

    if (!CloseHandle(hDriver))
    {
        printf("Failed to close device.\n");
    }


    // exit ///////////////////////////////////////////////////

    printf("\nLED DISPLAY updated.");
    printf("\n------------------------------------------------------\
            \nRunstream (R) MCPOS Windows NT Driver, Beta Rel. 00.02\
            \nCopyright (C) Unal Z, 2002. All rights reserved. #0212\n");

    exit(0);


} /* main */

///// End of code //////////////////////////////////////////////////
