// Copyright (C) UnalZ, 2002
// Runstream (R) MicroChannel Port Driver, NT 4.0 DDK
//--------------------------------------------------------------------------
// mpioctl.h	Public Include file for MCA POS I/O driver
// 				** Kernel and User mode **
//
// Define the IOCTL codes we will use.  The IOCTL code contains the device
// type value (user-defined for our driver), the IOCTL function control code,
// the type of buffering, and the type of file access.
//
// Define public constants and data structures
// ------------------------------------------------------------------------
//
// UZ changes:
//	Sep 2002 -- created based on DDK driver samples (portio and mono)
//	Dec 2002 -- moved to DDK 4.0, beta tests
//				starting with display effects
// ------------------------------------------------------------------------

#ifndef __MCPIOC_H__
#define __MCPIOC_H__

// Public DOS device name

#define MCPOS_DEVICE_NAME	"\\\\.\\MCPOS"

// Define the device type value. Device type values in the range 0-32767 are
// used by Microsoft Corp. Device types 32768-65535 are reserved for customers.

#define FILE_DEVICE_MCP 47795

// Macro definition for defining IOCTL function control codes.
// Function codes 0-2047 are reserved for Microsoft Corp. and
// 2048-4095 (0x800 to 0xFFF) are reserved for customers.

// PS/2 born in April 1987

#define MCP_IOCTL_INDEX 0x874

// I/O Control codes

#define IOCTL_MCP_READ_PLANAR 	CTL_CODE(FILE_DEVICE_MCP, \
    		  							 MCP_IOCTL_INDEX, \
    		  							 METHOD_BUFFERED, \
    		  							 FILE_ANY_ACCESS)

#define IOCTL_MCP_READ_SLOT 	CTL_CODE(FILE_DEVICE_MCP, \
    		  							 MCP_IOCTL_INDEX + 1, \
    		  							 METHOD_BUFFERED, \
    		  							 FILE_ANY_ACCESS)

#define IOCTL_MCP_WRITE_LED		CTL_CODE(FILE_DEVICE_MCP, \
    		  							 MCP_IOCTL_INDEX + 2, \
    		  							 METHOD_BUFFERED, \
    		  							 FILE_ANY_ACCESS)


// default POS bytes
#define MCP_MAX_POS		8

// max slot mumber
#define MCP_MAX_SLOT	8

// blank the display
#define MCP_BLANK_LED	"        "	// 8 spaces

// max LED line
#define MCP_MAX_LED		8

// LED display
typedef struct  _MCP_LED_DISPLAY
{
    UCHAR	Position;
    UCHAR	TextLength;
	CHAR	Text[MCP_MAX_LED];

}  MCP_LED_DISPLAY, *PMCP_LED_DISPLAY;


///// End of code //////////////////////////////////////////////////

#endif