/*
 * $Id: //devel/tools/main/rfc868time/defs.h#5 $
 *
 *	These are external function declarations that we use in the
 *	various modules, and this file must be #included by all of
 *	them to be sure that all of our decls are correct.
 */


// better /GS checking (VS2005 SP1 and later)
#pragma strict_gs_check(on)


// #define	FALSE	0
// #define	TRUE	1

#define SERVICENAME	"rfc868time"
#define	SERVICEDESC	"Unixwiz.net RFC868rdate time service"

#define DETAILEDDESC	_T("This is an RFC868 time verification service, which listens on port 37/tcp") \
			_T(" and responds to incoming connections with the current time, then") \
			_T(" closes the connection. It accepts no data from the client, and does") \
			_T(" not modify the local system's time.\n") \
			_T("\n") \
			_T("Though it does not perform time synchronization itself, it allows other") \
			_T(" software to verify the time on this (and perhaps other) machines to insure") \
			_T(" they are all synchronized. If not, they might raise an alert.\n") \
			_T("\n") \
			_T("See http://unixwiz.net/tools/rfc868time.html for more information\n") \
			_T("\n")

// how many *items*, not how many *bytes*
#define COUNTOF(x)	(sizeof(x) / sizeof((x)[0]) )

#define STRCASE(w)     case w: return _T(#w)

/*
 * xhdl()
 *
 *	We have never figured out why they don't use a NULL value for
 *	the non-handle, but we are determined to do it. This translates
 *	from INVALID_HANDLE_VALUE to NULL.
 */
inline HANDLE xhdl(HANDLE h)
{
	return (h == INVALID_HANDLE_VALUE) ? 0 : h;
}

extern void odprintf(const char *, ...);
extern void odprintf(const wchar_t *, ...);
#ifdef va_arg
extern void odprintva(const char    *, va_list args);
extern void odprintva(const wchar_t *, va_list args);
#endif

extern int		runningAsService,
			Debug;
extern BOOL		bShuttingDown;
extern HANDLE		hShutdownEvent;
extern int __stdcall	launch_service(void);
extern int __cdecl	internal_main(int argc, TCHAR **);
extern void __stdcall	mark_running(void);

extern const TCHAR * __stdcall prterr(DWORD err);
extern const TCHAR * __stdcall prterr(void);

extern void install_service(DWORD dwStartType, bool dostart);
extern void remove_service(void);

/*------------------------------------------------------------------*/

inline const TCHAR	*printable(BOOL bf)
			{ return bf ? _T("-true-") : _T("-false-"); }

