/*
 * $Id: //devel/tools/main/rfc868time/odprintf.cpp#2 $ -- 2000-01-12
 *
 * written by :	Stephen J. Friedl
 *		Software Consultant
 *		steve@unixwiz.net
 *
 *	This is a convenience wrapper for OutputDebugString() so that we
 *	can get reasonable printf-like formatting send to the debugging
 *	channel.
 *
 *	We provide "odprintf" which takes a printf-style variadic argument
 *	list, and "odprintva", which takes a format string plus a pointer
 *	to the va_list.
 *
 *	In all cases, we output >one< line at a time and always strip any
 *	trailing whitespace from the line (including newlines) before adding
 *	our own. 
 *
 *	We provide ANSI and UNICODE version.
 */
#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include <stdarg.h>
#include "defs.h"


/*
 * getbuf()
 *
 *	Given the base output buffer for this message, format any leading
 *	information required. This includes the thread ID so we can get
 *	an idea where the messages are coming from (particularly helpful
 *	when running as a service).
 *
 *	The return value is where the caller should start storing new
 *	information.
 */
void odprintva(const char *format, va_list args)
{
char	buf[256],
	*p    = buf,
	*pmax = buf + COUNTOF(buf) - 3;

	p += sprintf_s(p, (int)(pmax - p), "rdate: ");
	p += vsnprintf_s(p, (size_t)(pmax - p), (size_t)(pmax - p), format, args);

	while ( p > buf && isspace(*--p))
		*p = '\0';

	*++p = '\n';
	*++p = '\0';

	OutputDebugStringA(buf);
}


void odprintva(const wchar_t *format, va_list args)
{
wchar_t	buf[256],
	*p    = buf,
	*pmax = buf + COUNTOF(buf) - 3;

// _snwprintf_s
	p += _snwprintf_s(p, (size_t)(pmax - p), (size_t)(pmax - p), L"rdate: ");
	p += _vsnwprintf_s(p, (size_t)(pmax - p), (size_t)(pmax - p), format, args);

	while ( p > buf && iswspace(*--p))
		*p = '\0';

	*++p = '\n';
	*++p = '\0';

	OutputDebugStringW(buf);
}

void odprintf(const char *format, ...)
{
va_list	args;

	va_start(args, format);
	odprintva(format, args);
	va_end(args);
}

void odprintf(const wchar_t *format, ...)
{
va_list	args;

	va_start(args, format);
	odprintva(format, args);
	va_end(args);
}
