/*
 * $Id: //devel/tools/main/ygpm/notify.cpp#1 $
 *
 * written by :	Stephen J. Friedl
 *		Software Consultant
 *		steve@unixwiz.net
 *		2001/12/15
 *
 *	This is the module that deals with actual user notifications when
 *	a PM has arrived. We do support a "notify program" that the user
 *	can provide on the command line that we run when an IM arrives.
 *	This allows local customization.
 */
#include "ygpmcommon.h"
#include "ygpm.h"

#define	WINDOW_TITLE	"Unixwiz.net YGPM"

/*lint -esym(818, u) // ptr could be ptr to const */
void __stdcall notify_PM_present(IMUser *u)
{
	assert(u != 0);

	/*----------------------------------------------------------------
	 * RUN NOTIFY PROGRAM?
	 *
	 * If the user has given us a notify program, run it now. The
	 * parameters are the user ID and the display name, and the
	 * program can do whatever it likes.
	 */
	if ( Notify_program )
	{
	char	cmdbuf[256];

		sprintf(cmdbuf, "\"%s\" %ld \"%s\"",
			Notify_program,
			u->id(),
			u->name() );

		if ( Debug ) log("--> running {%s}", cmdbuf);

		(void) system(cmdbuf);
	}

#ifdef _WIN32

	/*----------------------------------------------------------------
	 * POP UP MESSAGE BOX
	 *
	 * Under Win32 we want to display a message box that shows
	 */
	char msgbuf[256];

	time_t now;

	time(&now);

	struct tm *t = localtime(&now);

	log("DSLR PM available for %s", u->name() );

	sprintf(msgbuf, "DSLR PM available for %s (at %02d:%02d)",
		u->name(),
		t->tm_hour,
		t->tm_min);

	UINT style = MB_OK;
//	style |= MB_TOPMOST;
	style |= MB_SYSTEMMODAL;	// top of all other windows

	MessageBox( NULL,               // owner window
	            msgbuf,             // text
	            WINDOW_TITLE,       // caption
	            style );            // style
#else

	log("DSLR PM available for %s", u->name() );

#endif

}
