/*
 * $Id: //devel/tools/main/ygpm/ygpm.h#1 $
 *
 * Written by : Stephen J. Friedl
 *              Software Consultant
 *              Tustin, California USA
 *              http://www.unixwiz.net
 *              2002/05/21
 *
 *      NOTE: This code is in the public domain
 *
 *	These are the definitions needed by the YGPM program. This includes
 *	the "housekeeping" definitions needed to make for a portable
 *	implementation (many of which we use in all the programs we write),
 *	the main class defintions, and external definitions.
 */

#ifndef TRUE
#  define	TRUE	1
#  define	FALSE	0
#endif

/*------------------------------------------------------------------------
 * Under Win32 we use explicit calling convention tokens, and these defs
 * allow their no-op use under UNIX.
 */
#ifndef _WIN32
#  define __cdecl	/* NOTHING */
#  define __stdcall	/* NOTHING */
#endif

/*------------------------------------------------------------------------
 * Random portability macros
 */

/*lint -emacro(732, sleep_seconds) // loss of sign */

#ifdef _WIN32
#  define SOCKET_IS_VALID(fd)   ((fd) != INVALID_SOCKET)
#  define EINPROGRESS           WSAEWOULDBLOCK
#  define socklen_t             int
#  define sleep_seconds(s)      Sleep((s)*1000)
#else
#  define SOCKET_IS_VALID(fd)   ((fd) >= 0 )
#  define closesocket(sfd)      close(sfd)
#  define SOCKET                int
#  define sleep_seconds(s)      sleep((s))
#endif

/*------------------------------------------------------------------------
 * We're a huge fan of GCC's __attribute__ feature, which allows us to
 * enable better compiler checking of our work, but we need to disable it
 * quietly if using another compiler.
 */
#ifndef __GNUC__
# define __attribute__(x)	/*nothing*/
#endif

/*------------------------------------------------------------------------
 * These can be used to shut up the compiler about variables that are
 * not used (those that we intend that way)
 */
#define UNUSED_PARAMETER(p)	(void)(p)	/* shut up compiler warnings */
#define UNUSED_VARIABLE(p)	(void)(p)	/* shut up compiler warnings */

/*------------------------------------------------------------------------
 * IMUser
 *
 * Each object of this type holds one DSL Reports user that we're going to
 * check via our fetching mechanism. We use a really weak object oriented
 * design here - it's little more than using a few C++ features in C (the
 * program just isn't big enough to warrant real data opacity).
 */
#define	MAXUSERS	3

/*lint -esym(1712, IMUser) // no default ctor defined */

class IMUser {
	/*----------------------------------------------------------------
	 * USERID / NAME
	 *
	 * These are the two bits of data that are populated by the user
	 * (during construction), and the only one that is *really* 
	 * required is the ID. The "name" is just used for display, and
	 * though it makes
	 */
private:
	long     m_userid;              // DSLR user ID
	char    *m_name;                // descriptive name

public:
	long        id(void)   const;
	const char *name(void) const;

public:
	char    *m_url;                 // full URL to fetch (incl proxy)
	int      m_urlsize;             // # of bytes in m_url
	int      m_have_PMs;            // do we have PMs now?

	char     m_readbuf[1024];	// web page fetched here

	void     have_PMs(int bf);


	IMUser(long userid, const char *name = 0 );     // constructor
	~IMUser();                                      // destructor

	void	build_request(const char *website,
	                      const char *useragent,
	                      const char *hostname);

	/*----------------------------------------------------------------
	 * TABLE OF USERS
	 */
	static IMUser  *m_users[MAXUSERS];
	static int      m_nusers;

	static int  usercount(void);
	static void add(long uid, const char *name);
	static void add(const char *idstring);
};

/* main.cpp */
extern int         Debug;
extern const char *Notify_program;
extern const char  Version[];
extern const char  fullVersion[];

/* util.cpp */
/*lint -sem(die, r_no) */
extern void __cdecl   die(const char *format, ...)
                                 __attribute__((format(printf,1,2)))
                                 __attribute__((noreturn));

extern void __cdecl   log(const char *format, ...)
                                 __attribute__((format(printf,1,2)));

/*lint -sem(init_timeval, 1p) */
/*lint -esym(534, init_timeval) // ignoring return value */
extern struct timeval *init_timeval( struct timeval *tv,
                                     long secs  = 0,
                                     long usecs = 0 );

extern int   timestamp_seconds;

/* winsock.cpp */
#ifdef _WIN32
extern void __stdcall init_winsock(int verbose, int level);
#endif

/* selectloop.cpp */
extern int __stdcall dorequest( SOCKET sfd,
                      const struct sockaddr_in *target,
                      IMUser *u,
                      int maxtime_secs );


extern SOCKET __stdcall create_nonblocking_socket(void);


/* notify.cpp */
extern void __stdcall notify_PM_present(IMUser *u);

/* wintray.cpp */
extern void __stdcall setup_windows(void);
