/*
 * $Id: //devel/tools/main/ygpm/utils.cpp#1 $
 *
 *	Utility functions that we use often throughout the code.
 */

#include "ygpmcommon.h"
#include <stdarg.h>
#include "ygpm.h"

int	timestamp_seconds = FALSE;

/*
 * die()
 *
 *	Given the customary printf-style parameter list, send the
 *	message to the standard error stream and exit with failure.
 */
void __cdecl die(const char *format, ...)
{
	va_list args;
	va_start(args, format);

	vfprintf(stderr, format,  args);
	va_end(args);

	putc('\n', stderr);

	/*----------------------------------------------------------------
	 * Under Win32, we want failures to be apparent and not just flash
	 * away, so we pause a bit before exiting.
	 */
#ifdef _WIN32
	const int exit_time = 5;

	fprintf(stderr, "exiting in %d seconds...", exit_time);

	sleep_seconds(exit_time);
#endif

	exit(EXIT_FAILURE);
}

/*
 * init_timeval()
 *
 *	Given the address of a timeval, *completely* initialize it.
 *	The default is zero, but we also can pass in the seconds and
 *	microseconds values.
 */

struct timeval *init_timeval(struct timeval *tv, long secs, long usecs)
{
        memset(tv, 0, sizeof *tv);

        tv->tv_sec  = secs;
        tv->tv_usec = usecs;

	return tv;
}

/*
 * log()
 *
 *	Given a printf-style message, format it to the standard output
 *	along with a time indicator. We strip off trailing whitespace
 *	and then append a newline.
 */
void __cdecl log(const char *format, ...)
{
	char fmtbuf[256],
	     *p = fmtbuf;

	// figure out the time
	time_t now;
	time(&now);
	struct tm *t = localtime(&now);

	p += sprintf(p, "%02d:%02d", t->tm_hour, t->tm_min);

	if ( timestamp_seconds )
	 p += sprintf(p, ":%02d", t->tm_sec);

	*p++ = ' ';

	// now format the user's parameters themselves
	va_list args;
	va_start(args, format);

	p += vsprintf(p, format, args);

	while ( p > fmtbuf  &&  isspace(p[-1]) )
		p--;

//	*p++ = '\n';		// if we're not using 
	*p   = '\0';

	puts(fmtbuf);
}
